function drawall_one()
set(0,'DefaulttextInterpreter','none')
filenames = dir('*.txt');

num = size(filenames);

num = num(1);
figure
set(0,'DefaultAxesColorOrder',[0 0 1 ; 0 1 0 ; 0 0 0 ; 0 0 1 ; 0 1 0 ; 0 0 0; 0 0 1]) 
subplot(1,2,1);
title('Linear')
hold on;

subplot(1,2,2);
  
title('dB')
hold on;
cc=hsv(12);

for m = 1:num
    subplot(1,2,1);
    fid = fopen(filenames(m).name);
    temp = fscanf(fid,'%f',[1 inf]);
    plot(temp,'-', 'LineWidth',1, 'LineSmoothing','on','color',cc(m,:))
    axis([1 128 0 15])
    hold on;
    
    subplot(1,2,2);
    plot(20*log10(temp),'-', 'LineWidth',1, 'LineSmoothing','on','color',cc(m,:))
    axis([1 128 -90 22])
    hold on;
    fclose(fid);
end

% figure with all plots in one
figure
for m = 1:num
    fid = fopen(filenames(m).name);
    legendInfo{m} = [filenames(m).name(10:end-4)];
    temp = fscanf(fid,'%f',[1 inf]);
    plot(20*log10(temp),'-', 'LineWidth',1, 'LineSmoothing','on','color',cc(m,:))
    hold on;
    fclose(fid);
end

% plot(0*ones(128),'--','color','blue');
plot(6*ones(128),'--','color','red');
plot(12*ones(128),'--','color','green');

xlabel('MIDI Value');
ylabel('Level [dB]');
axis([1 128 -90 22]);
title('Comparison of Midi Fader behaviour');
legend(legendInfo,'Location','Best');
print('-dpdf','-r300','results/all-in-one.pdf')