function drawall()
set(0,'DefaulttextInterpreter','none')
filenames = dir('*.txt');

num = size(filenames);

num = num(1);
for m = 1:num
    figure(m);
    fid = fopen(filenames(m).name);
    temp = fscanf(fid,'%f',[1 inf]);
    plot(20*log10(temp),'-', 'LineWidth',1, 'LineSmoothing','on')
    hold on;
    plot(6*ones(128),'--');
    axis([1 128 -90 22])
    xlabel('MIDI Value');
    ylabel('Level [dB]');
    legend(filenames(m).name(10:end-4),'Location','NorthWest');
    title(filenames(m).name)
    fclose(fid);
    print('-dpdf','-r300',sprintf('results/%s.pdf',filenames(m).name(1:end-4)))
end